
unit WebForm1;

interface

uses
  System.Collections, System.ComponentModel,
  System.Data, System.Drawing, System.Web, System.Web.SessionState,
  System.Web.UI, System.Web.UI.WebControls, System.Web.UI.HtmlControls, 
  System.Data.SqlClient;

type
  TWebForm1 = class(System.Web.UI.Page)
  {$REGION 'Designer Managed Code'}
  strict private
    procedure InitializeComponent;
  {$ENDREGION}
  strict private
    procedure Page_Load(sender: System.Object; e: System.EventArgs);
  strict protected
    DataGrid1: System.Web.UI.WebControls.DataGrid;
    Button1: System.Web.UI.WebControls.Button;
    procedure OnInit(e: EventArgs); override;
  private
    procedure GetData;
  public
    { Public Declarations }
  end;

implementation
     uses System.Configuration, System.Web.Caching;
     
{$REGION 'Designer Managed Code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TWebForm1.InitializeComponent;
begin
  Include(Self.Load, Self.Page_Load);
end;
{$ENDREGION}

procedure TWebForm1.Page_Load(sender: System.Object; e: System.EventArgs);
begin
 // if not isPostBack then
    GetData;
end;

procedure TWebForm1.OnInit(e: EventArgs);
begin
  InitializeComponent;
  inherited OnInit(e);
end;

procedure TWebForm1.GetData;
var
  SqlConn: SqlConnection;
  SqlData: SqlDataAdapter;
  Dt     : DataSet;
  strSQL : string;
begin
  if not Assigned(Cache['DT']) then
  begin
    SqlConn := SqlConnection.Create(ConfigurationSettings.AppSettings.Item['ConnectionString']);
    strSQL  := 'SELECT * FROM CUSTOMERS';
    SqlData := SqlDataAdapter.Create(strSQL, SqlConn);
    Dt      := DataSet.Create;
    SqlData.Fill(Dt);

    Cache.Insert('DT', Dt, nil,
    Cache.NoAbsoluteExpiration, TimeSpan.FromMinutes(1), CacheItemPriority.Default, nil);
  end;
  DataGrid1.DataSource := Dataset(Cache['DT']);
  DataGrid1.DataBind;
end;

end.

